



/************************************************
 **                                            **
 **   Ex2.Board-GLCD InterFace Key4x3          **
 **                                            **
 **   PC0-PC3 = OUTPUT Connect Key Row         **
 **   PC4-PC6 = INPUT  Connect Key Colum       **
 **   PA4     = Rx0 (RS232 CH0)                ** 
 **   PA5     = Tx0                            **
 **   Baud Rate : 115200 at Clock =18.432 Mhz  **
 **   MCU       : Z8F6422                      **
 **   Compiler  : ZDSII                        **
 **                                            **
 **   Write by  : Sittiphol Yooyod             **
 ************************************************/       

  #include <stdio.h>
  #include <ez8.h> 
              
  unsigned char code,esc=0x1B,enter=0x0D,count=0 ;
                            
//-------------------- Delay -----------------------

  void delay (int count)
   {
    int i,j;
        for(i=0;i<=count;i++)
    	for(j=0;j<=count;j++);
   }

//------------ Check Respond Command ---------------

void acho()
 { 
  unsigned char O,K;

  
  do{
     O = getchar()   ;        //Read Respond 'O'  
    }while(O != 'O') ;
  
  do{
     K = getchar()   ;         //Read Respond 'K'
	}while(K !='K')  ;

 }

//------------------- Setup GLCD ------------------

 void Set_GLCD()
  {
    count = 0 ;
	
	printf("%c00#30=000,00%c",esc,enter)                 ;  //Sent Cmm Set Cursor x,y=[0,0]
	acho();
	
	printf("%c00#32=2:#Key Number 10 digit:%c",esc,enter);  //Sent Cmm Plot Text
	acho();

    printf("%c00#30=030,25%c",esc,enter)                 ;  //Sent Cmm Set Cursor x,y=[30,25]
	acho();

    printf("%c00#34=1%c",esc,enter)                      ;  //Sent Cmm Cursor On
	acho();
  }

//------------------- Check key 4x3 ------------------

void Check_key()
 {
  unsigned char m,div,ch[3] ;
 

   switch(code)
    {
       case 0xEE :
	              printf("%c00#04=2,1%c",esc,enter);  //Sent Cmm Sound
				  acho();
                
                  printf("%c00#31=1:1%c",esc,enter);  //Display '1' on GLCD
				  acho();
				  count++;
	              break;
    
       case 0xDE :
                  printf("%c00#04=2,1%c",esc,enter);  //Sent Cmm Sound
				  acho();


                  printf("%c00#31=1:2%c",esc,enter); //Display '2' on GLCD
				  acho();
				  count++;
	              break;

	   case 0xBE :
                  printf("%c00#04=2,1%c",esc,enter);  //Sent Cmm Sound
				  acho();

                  printf("%c00#31=1:3%c",esc,enter);  //Display '3' on GLCD
				  acho();
				  count++;
	              break;

       case 0xED :
                  printf("%c00#04=2,1%c",esc,enter);  //Sent Cmm Sound
				  acho();

                  printf("%c00#31=1:4%c",esc,enter);  //Display '4' on GLCD
				  acho();
				  count++;
	              break;

       case 0xDD :
                  printf("%c00#04=2,1%c",esc,enter);  //Sent Cmm Sound
				  acho();

                  printf("%c00#31=1:5%c",esc,enter); //Display '5' on GLCD
				  acho();
				  count++;
                  break;

       case 0xBD :
                  printf("%c00#04=2,1%c",esc,enter);  //Sent Cmm Sound
				  acho();

                  printf("%c00#31=1:6%c",esc,enter); //Display '6' on GLCD
				  acho();
				  count++;
                  break;

       case 0xEB :
	              printf("%c00#04=2,1%c",esc,enter);  //Sent Cmm Sound
				  acho();

                  printf("%c00#31=1:7%c",esc,enter); //Display '7' on GLCD
				  acho();
				  count++;
                  break;

       case 0xDB :
                  printf("%c00#04=2,1%c",esc,enter);  //Sent Cmm Sound
				  acho();
  
                  printf("%c00#31=1:8%c",esc,enter); //Display '8' on GLCD
				  acho();
				  count++;
                  break;

       case 0xBB :
                  printf("%c00#04=2,1%c",esc,enter);  //Sent Cmm Sound
				  acho();

                  printf("%c00#31=1:9%c",esc,enter); //Display '9' on GLCD
				  acho();
				  count++;
                  break;


       case 0xE7 :
                  printf("%c00#04=6,4%c",esc,enter);  //Sent Cmm Sound
				  acho();

                  printf("%c00#00=%c",esc,enter);     //Clear Screen(*)
				  acho();

				  Set_GLCD();
                  break;
 
	   case 0xD7 :
                  printf("%c00#04=2,1%c",esc,enter);  //Sent Cmm Sound
				  acho();  

                  printf("%c00#31=1:0%c",esc,enter);  //Display '0' on GLCD
				  acho();
				  count++;
                  break;

	   case 0xB7 :
	              if((count>0)&&(count<11))             //Check del Text no exceed 10 digit
				  {
                    printf("%c00#04=7,1%c",esc,enter);  //Sent Cmm Sound
				    acho();
                    printf("%c00#33=2%c",esc,enter)  ;  //Del Text (#)
				    acho();
                    count--;
				   }
				  
                  break;

	}
    
	while(code != 0xF0) // Protect Press Repeat Key.
	 {
	  code  = PCIN  ;   // Read Code Key
	  code |=0x80   ;   //Set PC7=1 
      code &=0xF0   ;
	 }

  //------------ Check Digit Number ---------------

   if(count==10)        //if Press Key = 10 digit 
    {
     count = 0   ;
    
     printf("%c00#34=0%c",esc,enter);                 //Sent Cmm Cursor Off
	 acho()      ;
	 delay(300)  ;
    
	 printf("%c00#14=030,31,110,37,2%c",esc,enter);  //Sent Cmm Rectang Del Text
     acho()      ;


     printf("%c00#14=015,35,110,39,0%c",esc,enter);  //Sent Cmm Buile Rectang 
     acho()      ;
    
	 delay(300)  ;
	 ch[0] = '0' ;                                   //Position Axle X for Rectang
	 ch[1] = '2' ;
	 ch[2] = '0' ;
	 m     = 20  ;

     while(m<=110)
	  {
       printf("%c00#14=015,35,%c%c%c,39,1%c",esc,ch[0],ch[1],ch[2],enter);  //Sent Cmm Buile Rectang back 
       acho()    ;
	   delay(250);
       
	   m= m+5    ;                                   //decimal Position Axle X
       
	   //----- Convert decimal to Ascii -------
       
	   div   =  m/100         ;
       ch[0] =  div+0x30      ;

	   div   =  m%100         ;
	   ch[1] =  (div/10)+0x30 ;
	   
	   div   =  div%10        ;
	   ch[2] =  div+0x30      ;

	 }
     
  //------------ Sound --------------
    for(m=0;m<6;m++)
     {
	  printf("%c00#04=3,7%c",esc,enter);  //Sent Cmm Sound 
	  acho();
	  delay(600);
     }

     for(m=0;m<3;m++)
     {
	  printf("%c00#04=2,2%c",esc,enter);  //Sent Cmm Sound 
	  acho();
	  delay(150);
      printf("%c00#04=2,2%c",esc,enter);  //Sent Cmm Sound 
	  acho();
	  delay(150);
      printf("%c00#04=2,4%c",esc,enter);  //Sent Cmm Sound 
	  acho();
	  delay(200);
     }

   
   	printf("%c00#14=015,35,110,39,2%c",esc,enter); //Sent Cmm Rectang Del Rectang back
    acho();  
  
    printf("%c00#30=030,25%c",esc,enter)         ; //Sent Cmm Set Cursor (30,25)
	acho();

    printf("%c00#34=1%c",esc,enter)              ; //Sent Cmm Cursor ON
	acho();	

   } //if count
 }   // Switch



//********************* Main **********************

   void main(void)
    {    
      U0BRH  = 0x00  ;   
      U0BRL  = 10    ;   //Set Baud Rate 11520=10 
      PAAF   = 0x30  ;   //Set Altternet Function PA4-5 for Urat 0
      U0CTL0 = 0xC0  ;   //Control Register Uart0 Function
      
	  PCDD  = 0xF0   ;   //set Port PC0-PC3=Output;PC4-PC7=Input
    
      printf("%c00#00=%c",esc,enter);  //Sent Cmm Clear Screen
	  acho()         ;
      Set_GLCD()     ;

      while(1)
	   {
        PCOUT = 0xFE  ; //Set PC0=0 Scan Row1
	    delay(50)     ;
	    code = PCIN   ; //Read code Port.C 
	    code |=0x80   ; //Set PC7=1
	    Check_key()   ; //Check press key 1-2-3

        PCOUT = 0xFD  ; //Set PC1=0 Scan Row2
	    delay(50)     ;
	    code = PCIN   ; //Read code Port.C
	    code |=0x80   ; //Set PC7=1
	    Check_key()   ; //Check press key 4-5-6

	    PCOUT = 0xFB  ; //Set PC2=0 Scan Row3
	    delay(50)     ;
	    code = PCIN   ; //Read code Port.C
	    code |=0x80   ; //Set PC7=1
	    Check_key()   ; //Check press key 7-8-9

	    PCOUT = 0xF7  ; //Set PC3=0 Scan Row4
	    delay(50)     ;
	    code = PCIN   ; //Read code Port.C
	    code |=0x80   ; //Set PC7=1
	    Check_key()   ; //Check press key *-0-#
	 }
   }















